#!/bin/sh

TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_OK="DTAS[TUI]@{OK}"
TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CANCEL="DTAS[TUI]@{CANCEL}"
TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CTRLC="DTAS[TUI]@{CTRLC}"
TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_ERROR="DTAS[TUI]@{ERROR}"
TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE=""

TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG=""

TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_SELECT=""
TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH=""
TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX=""

tp_esxi_image_select_checklist() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    local title="${1}"
    local text="${2}"
    local label_ok="${3}"
    local label_cancel="${4}"
    local esxi_ip="${5}"
    local esxi_username="${6}"
    local esxi_password="${7}"
    local prefix="${8:-all}"
    local condition="${9:-none}"
    local sb_number="${10:-24}"
    
    local ret
    utility_get_esxi_all_vmx_files \
        "${esxi_ip}" \
        "${esxi_username}" \
        "${esxi_password}" \
        "${prefix}" \
        "${condition}"
    ret="${?}"
    if [ "${ret}" -eq 2 -o "${ret}" -eq 130 ]; then
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CTRLC}"
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG=""
        return
    
    elif [ "${ret}" -ne 0 ]; then
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_ERROR}"
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG="${TP_ESXI_IMAGE_SELECT_ERROR_GET_ALL_VMX_FILES}"
        return
        
    elif [ -z "${UTILITY_GET_ESXI_ALL_VMX_FILES_MSG}" ]; then
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_ERROR}"
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG="${ERROR_ESXI_CANNOT_GET_IMAGE_PATH_SB}"
        return
    fi
    debug_print "vmx files: ${UTILITY_GET_ESXI_ALL_VMX_FILES_MSG}"
    
    
    ##################################################
    # pick up vmx files with
    #     specific prefix: DDA_
    #     no postfix: _ORIGIN, _1, _2, _3, ..., _24
    ##################################################
    local vmx_files_to_display="${UTILITY_GET_ESXI_ALL_VMX_FILES_MSG}"
    debug_print "vmx files to display: ${vmx_files_to_display}"
    
    
    ##################################################
    # translate long format to short format
    #   ex. /vmfs/volumes/<ds_uid>/A/A.vmx => A
    ##################################################
    local short_names
    local vmx_file
    for vmx_file in $vmx_files_to_display
    do
        local file_name=`echo "${vmx_file}" | awk 'BEGIN {FS="/"} {print $6}'`
        local short_format="`echo "${file_name}" | sed "s/.vmx$//g"`"
        
        # no need to display sandbox prefix(DDA_) on menu, filter out it.
        [ "${prefix}" == "${conf_sb_prefix}" ] && \
            short_format="`echo "${short_format}" | sed "s/^${prefix}//g"`"
        
        [ -z "${short_names}" ] && \
            short_names="${short_format}" || \
            short_names="${short_names} ${short_format}"
    done
    
    # change to array type
    debug_print "vmx files to display(short version): ${short_names}"
    local short_names_array=(${short_names})
    local long_names_array=(${vmx_files_to_display})
    
    ##################################################
    # composing menu list to display on TUI
    ##################################################
    local menu_list=""
    local i
    for ((i=0; i<${#short_names_array[@]}; i++)); do
        local short_name="${short_names_array[$i]}"
        local long_name="${long_names_array[$i]}"

        utility_get_image_type_id_by_vmpath \
            "${long_name}"
        local msg="${UTILITY_GET_IMAGE_TYPE_ID_BY_VMPATH_MSG}"
        if [ "${?}" -ne 0 ]; then
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_ERROR}"
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG="${TP_ESXI_IMAGE_SELECT_ERROR_GET_IMAGE_TYPE_ID}:${msg}"
            return
        fi
        local image_type_id="${msg}"
        debug_print "GetImageTypeId: vmx='${long_name}', id='${image_type_id}'"

        
        ##################################################
        # append usage info for each short names.
        #   ex. A (x of y sandboxes)
        ##################################################
        
        # get how many cloned sandboxes are used
        local sandboxes_count="0"
        local msg
        local ret
        msg=`dtascfg /etc/dtascfg.xml get image_type image_${image_type_id}/isActive 2>1`
        ret="${?}"
        
        # check if image type already exists
        debug_print "CheckIfImageTypeExist: id='${image_type_id}'"
        
        # when Xpath not exist
        if [ "${ret}" -ne 0 ]; then
            debug_print "ImageTypeNotExist: ret='${ret}', msg='${msg}'"
            debug_print "ResetSandboxesCount: 0"
            sandboxes_count="0"

        # when 'isActive' = 0
        elif [ "${msg}" -eq 0 ]; then
            debug_print "ImageTypeExistButNotActive: id='${image_type_id}', isActive='${msg}'"
            debug_print "ResetSandboxesCount: 0"
            sandboxes_count="0"
        
        # when 'isActive' = 1
        else
            debug_print "ImageTypeExistAndActive: id='${image_type_id}', isActive='${msg}'"
            debug_print "GetSandboxesCount: id='${image_type_id}'"
            
            msg=`dtascfg /etc/dtascfg.xml get image_type image_${image_type_id}/sandboxes/count 2>1`
            ret="${?}"
            if [ "${ret}" -ne 0 ]; then
                debug_print "GetSandboxesCountFail: id='${image_type_id}', ret='${ret}', msg='${msg}'"
                debug_print "ResetSandboxesCount: 0"
                sandboxes_count="0"
            else
                debug_print "GetSandboxesCountPass: id='${image_type_id}', sbxCount='${msg}'"
                debug_print "ResetSandboxesCount: ${msg}"
                sandboxes_count="${msg}"
            fi
        fi
        
        # append
        # menu_list="${menu_list} \"${short_name}\" \"(${sandboxes_count} of ${sb_number} sandboxes)\""
        menu_list="${menu_list} \"${short_name}\" \"(${sandboxes_count} of ${sb_number} sandboxes)\""
        
        
        ##################################################
        # Check if menu items should be checked or not
        ##################################################
        
        # user ever choosed something on sandbox menu, this has higher priority to display
        if [ -n "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_SELECT}" ]; then
            local found="no"
            local user_choose
            for user_choose in ${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_SELECT}
            do
                if [ "${user_choose}" = "${short_name}" ]; then
                    menu_list="${menu_list} ON"
                    found="yes"
                    break
                fi
            done
            
            [ "${found}" = "no" ] && \
                menu_list="${menu_list} OFF"
            
        # lookup file "NewSBGroupInfoESXi" for user's current sandbox configuration
        elif [ -s "${NEW_SB_GROUP_INFO_ESXI_FILE}" ]; then
            [ -n "`cat "${NEW_SB_GROUP_INFO_ESXI_FILE}" | grep "${long_name}"`" ] && \
                menu_list="${menu_list} ON" || \
                menu_list="${menu_list} OFF"
        
        else
            menu_list="${menu_list} OFF"
        fi
    done
    
    debug_print "GetMenuList: ${menu_list}"

    
    ##################################################
    # display checklist
    ##################################################
    tp_checklist_ok_cancel \
        "${title}" \
        "${text}" \
        "${label_ok}" \
        "${label_cancel}" \
        "${menu_list}"
 
    case "${TP_CHECKLIST_OK_CANCEL_RESULT_CODE}" in
        "${TP_CHECKLIST_OK_CANCEL_RESULT_CANCEL}" )
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE="$TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CANCEL"
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG=""
            return ;;
    esac


    # nothing is selected
    if [ -z "${TP_CHECKLIST_OK_CANCEL_RESULT_SELECT}" ]; then
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_SELECT=""
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH=""
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX=""
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_OK}"
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG=""
        return
    fi
    
    # delete '\' and '"'
    TP_CHECKLIST_OK_CANCEL_RESULT_SELECT="${TP_CHECKLIST_OK_CANCEL_RESULT_SELECT//\\/}"
    TP_CHECKLIST_OK_CANCEL_RESULT_SELECT="${TP_CHECKLIST_OK_CANCEL_RESULT_SELECT//\"/}"

    debug_print "UserSelect(Short): ${TP_CHECKLIST_OK_CANCEL_RESULT_SELECT}"
    TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_SELECT="${TP_CHECKLIST_OK_CANCEL_RESULT_SELECT}"
    
    
    ##################################################
    # get corresponding long format according to user selects
    #   ex. /vmfs/volumes/<datastore_uid>/sandbox/sandbox.vmx
    ##################################################    
    local long_names_user_selects
    local user_select
    for user_select in ${TP_CHECKLIST_OK_CANCEL_RESULT_SELECT}
    do
        local i
        for ((i=0; i<${#short_names_array[@]}; i++)); do
            local sn="${short_names_array[$i]}"
            if [ "${user_select}" = "${sn}" ]; then
                local ln="${long_names_array[$i]}"
                
                [ -z "${long_names_user_selects}" ] && \
                    long_names_user_selects="${ln}" || \
                    long_names_user_selects="${long_names_user_selects},${ln}"
            fi
        done
    done
    debug_print "UserSelect(Long): ${long_names_user_selects}"
    TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH="${long_names_user_selects}"

    
    ##################################################
    # get corresponding long format (VIX) according to user selects
    #   ex. [ha-datacenter/<datastore_name>] sandbox/sandbox.vmx
    ##################################################    
    TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX=""
    
    # turn-on esxi sshd services
    utility_tui_signal_lock
    utility_open_esxi_service_sshd \
        "${esxi_ip}" \
        "${esxi_username}" \
        "${esxi_password}"
    ret="${?}"
    if [ "${ret}" -eq 2 -o "${ret}" -eq 130 ]; then
        debug_print "EnableESXiServiceSshdCtrlC: ret='${ret}', msg='${UTILITY_OPEN_ESXI_SERVICE_SSHD_MSG}'"
    
        utility_tui_signal_unlock
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_SELECT="${TP_CHECKLIST_OK_CANCEL_RESULT_SELECT}"
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX=""
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CTRLC}"
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG="${UTILITY_OPEN_ESXI_SERVICE_SSHD_MSG}"
        return "${ret}"
    
    elif [ "${ret}" -ne 0 ]; then
        debug_print "EnableESXiServiceSshdFail: ret='${ret}', msg='${UTILITY_OPEN_ESXI_SERVICE_SSHD_MSG}'"
        
        utility_tui_signal_unlock
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_SELECT="${TP_CHECKLIST_OK_CANCEL_RESULT_SELECT}"
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX=""
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_ERROR}"
        TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG="${UTILITY_OPEN_ESXI_SERVICE_SSHD_MSG}"
        return "${ret}"
    fi
    
    # convert
    local vm_path_vsphere
    for vm_path_vsphere in `echo "${long_names_user_selects}" | sed 's/,/ /g'`
    do
        debug_print "ConvertVmpathFromVsphereToVix: vmPathVsphere='${vm_path_vsphere}'"	
        
        local msg
        msg=`php $CONS_BACKEND convert_esxi_vmpath_from_vsphere_to_vix \
            "${esxi_ip}" \
            "${esxi_username}" \
            "${esxi_password}" \
            "${vm_path_vsphere}"`
        local ret="${?}"
        if [ "${ret}" -eq 2 -o "${ret}" -eq 130 ]; then
            debug_print "ConvertVmpathFromVsphereToVixCtrlC: ret='${ret}', msg='${msg}'"
        
            utility_tui_signal_unlock
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_SELECT="${TP_CHECKLIST_OK_CANCEL_RESULT_SELECT}"
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX=""
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CTRLC}"
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG="${TP_ESXI_IMAGE_SELECT_ERROR_CONVERT_TO_ESXI_VMPATH}: ${vm_path_vsphere}"
            return "${ret}"
        
        elif [ "${ret}" -ne 0 ]; then
            debug_print "ConvertVmpathFromVsphereToVixFail: ret='${ret}', msg='${msg}'"	
            
            utility_tui_signal_unlock
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_SELECT="${TP_CHECKLIST_OK_CANCEL_RESULT_SELECT}"
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX=""
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_ERROR}"
            TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG="${TP_ESXI_IMAGE_SELECT_ERROR_CONVERT_TO_ESXI_VMPATH}: ${vm_path_vsphere}"
            return "${ret}"
        fi
        debug_print "ConvertVmpathFromVsphereToVixPass: vmPathVsphere='${vm_path_vsphere}', vmPathVix='${msg}'"	

        # append to variable
        [ -z "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX}" ] \
            && TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX="${msg}" \
            || TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX},${msg}"
    done
    
    # done
    debug_print "UserSelect(VIX): ${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX}"

    # turn-off esxi sshd service
    utility_close_esxi_service_sshd \
        "${esxi_ip}" \
        "${esxi_username}" \
        "${esxi_password}"
    utility_tui_signal_unlock
    
    TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_OK}"
    TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG=""
    return
}
